<?php
require_once 'config.php';
require_once 'header.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = $conn->real_escape_string($_POST['full_name']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $skills = $conn->real_escape_string($_POST['skills']);
    
    // Profile picture upload
    if (!empty($_FILES['profile_pic']['name'])) {
        $target_dir = "assets/profile/";
        $file_name = uniqid() . '_' . basename($_FILES["profile_pic"]["name"]);
        $target_file = $target_dir . $file_name;
        
        if (move_uploaded_file($_FILES["assets/profile/"]["tmp_name"], $target_file)) {
            $conn->query("UPDATE users SET profile_pic='$target_file' WHERE id=$user_id");
        }
    }
    
    $sql = "UPDATE users SET 
            full_name='$full_name', 
            phone='$phone', 
            skills='$skills' 
            WHERE id=$user_id";
    
    if ($conn->query($sql)) {
        header("Location: dashboard.php");
        exit;
    }
}
?>

<div class="container mt-5">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Edit Profile</h4>
                </div>
                <div class="card-body">
                    <form method="post" enctype="multipart/form-data">
                        <div class="mb-3">
                            <label>Full Name</label>
                            <input type="text" name="full_name" class="form-control" 
                                   value="<?= htmlspecialchars($user['full_name']) ?>" required>
                        </div>
                        
                        <div class="mb-3">
                            <label>Email</label>
                            <input type="email" class="form-control" 
                                   value="<?= htmlspecialchars($user['email']) ?>" disabled>
                        </div>
                        
                        <div class="mb-3">
                            <label>Phone</label>
                            <input type="tel" name="phone" class="form-control" 
                                   value="<?= htmlspecialchars($user['phone']) ?>">
                        </div>
                        
                        <?php if ($user['user_type'] === 'freelancer'): ?>
                        <div class="mb-3">
                            <label>Skills</label>
                            <input type="text" name="skills" class="form-control"
                                   value="<?= htmlspecialchars($user['skills']) ?>"
                                   placeholder="Separate skills with commas">
                        </div>
                        <?php endif; ?>
                        
                        <div class="mb-3">
                            <label>Profile Picture</label>
                            <input type="file" name="profile_pic" class="form-control">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Update Profile</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?>