<?php
require_once 'config.php';
require_once 'header.php';

$search = isset($_GET['search']) ? $conn->real_escape_string($_GET['search']) : '';
$category = isset($_GET['category']) ? $conn->real_escape_string($_GET['category']) : '';
$min_budget = isset($_GET['min_budget']) ? (float)$_GET['min_budget'] : 0;
$max_budget = isset($_GET['max_budget']) ? (float)$_GET['max_budget'] : 10000;

// Build query
$query = "SELECT * FROM gigs WHERE status='open' ";
if (!empty($search)) {
    $query .= "AND (title LIKE '%$search%' OR description LIKE '%$search%') ";
}
if (!empty($category)) {
    $query .= "AND category='$category' ";
}
$query .= "AND budget BETWEEN $min_budget AND $max_budget ORDER BY created_at DESC";

$result = $conn->query($query);
?>

<div class="container mt-5">
    <div class="row">
        <div class="col-md-3">
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">Filter Gigs</h5>
                    <form id="searchForm">
                        <div class="mb-3">
                            <input type="text" name="search" class="form-control" 
                                   placeholder="Search..." value="<?= $search ?>">
                        </div>
                        <div class="mb-3">
                            <select name="category" class="form-select">
                                <option value="">All Categories</option>
                                <option value="Writing" <?= $category === 'Writing' ? 'selected' : '' ?>>Writing</option>
                                <option value="Design" <?= $category === 'Design' ? 'selected' : '' ?>>Design</option>
                                <option value="Programming" <?= $category === 'Programming' ? 'selected' : '' ?>>Programming</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label>Budget Range ($)</label>
                            <div class="row">
                                <div class="col">
                                    <input type="number" name="min_budget" class="form-control" 
                                           placeholder="Min" value="<?= $min_budget ?>">
                                </div>
                                <div class="col">
                                    <input type="number" name="max_budget" class="form-control" 
                                           placeholder="Max" value="<?= $max_budget ?>">
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">Apply Filters</button>
                    </form>
                </div>
            </div>
        </div>

        <div class="col-md-9">
            <div class="row" id="searchResults">
                <!-- Results will be loaded here via AJAX -->
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    // Load initial results
    loadResults();
    
    // Handle form submission
    $('#searchForm').on('submit', function(e) {
        e.preventDefault();
        loadResults();
    });
    
    function loadResults() {
        $.ajax({
            url: 'search-ajax.php',
            data: $('#searchForm').serialize(),
            success: function(data) {
                $('#searchResults').html(data);
            }
        });
    }
});
</script>

<?php require_once 'footer.php'; ?>